package org.example;
import java.util.HashMap;
import java.util.Map;
enum Color {
    RED, GREEN, BLUE
}

enum RGB {
    RED, GREEN, BLUE
}
enum PrimaryColor {
    RED, YELLOW, BLUE
}

enum Size {
    SMALL, MEDIUM, LARGE;

    public Weight convertToWeight() {
        switch (this) {
            case SMALL:
                return Weight.LIGHT;
            case MEDIUM:
                return Weight.MEDIUM;
            case LARGE:
                return Weight.HEAVY;
            default:
                throw new IllegalArgumentException("Unsupported size: " + this);
        }
    }
}

enum Weight {
    LIGHT, MEDIUM, HEAVY
}

interface Convertible {
    Length convert();
}

enum Distance implements Convertible {
    METER {
        public Length convert() {
            return Length.METER;
        }
    },
    KILOMETER {
        public Length convert() {
            return Length.KILOMETER;
        }
    }
}

enum Length {
    METER, KILOMETER
}

public class Main {
    public static void main(String[] args) {
        Color color = Color.RED;
        RGB rgb = RGB.valueOf(color.name());
        System.out.println(rgb);

        Map colorMap = new HashMap<>();
        colorMap.put(Color.RED, PrimaryColor.RED);
        colorMap.put(Color.GREEN, PrimaryColor.YELLOW);
        colorMap.put(Color.BLUE, PrimaryColor.BLUE);

        Color color1 = Color.GREEN;
        PrimaryColor primaryColor = (PrimaryColor) colorMap.get(color1);
        System.out.println(primaryColor);

        Size size = Size.SMALL;
        Weight weight = size.convertToWeight();
        System.out.println(weight);

        Distance distance = Distance.METER;
        Length length = distance.convert();
        System.out.println(length);
    }
}
